/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.entity.OstrichEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class OstrichModel<T extends OstrichEntity>
extends AdvancedEntityModel<T> {
    private boolean isLayingEgg;
    private boolean isBuildingNest;
    private final ModelPart Body;
    private final ModelPart Head;
    private final ModelPart Neck;
    private final ModelPart NeckTop;
    private final ModelPart LeftLegTop;
    private final ModelPart LeftLegBottom;
    private final ModelPart LeftFoot;
    private final ModelPart RightLegTop;
    private final ModelPart RightLegBottom;
    private final ModelPart RightFoot;

    public OstrichModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Neck = this.Body.m_171324_("Neck");
        this.NeckTop = this.Neck.m_171324_("NeckTop");
        this.Head = this.NeckTop.m_171324_("Head");
        this.LeftLegTop = this.Body.m_171324_("LeftLegTop");
        this.LeftLegBottom = this.LeftLegTop.m_171324_("LeftLegBottom");
        this.LeftFoot = this.LeftLegBottom.m_171324_("LeftFoot");
        this.RightLegTop = this.Body.m_171324_("RightLegTop");
        this.RightLegBottom = this.RightLegTop.m_171324_("RightLegBottom");
        this.RightFoot = this.RightLegBottom.m_171324_("RightFoot");
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.isLayingEgg = ((OstrichEntity)entity).isLayingEgg();
        this.isBuildingNest = ((OstrichEntity)entity).isBuildingNest();
        this.Head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.Head.f_104204_ = netHeadYaw / 3.75f * ((float)Math.PI / 180);
        this.NeckTop.f_104203_ = this.Head.f_104203_ / 1.75f;
        this.Neck.f_104204_ = this.Head.f_104204_ / 1.75f;
        if (this.isLayingEgg) {
            this.LeftLegTop.f_104203_ = 1.1780972f;
            this.LeftLegBottom.f_104203_ = -2.5743606f;
            this.LeftFoot.f_104203_ = 0.61086524f;
            this.RightLegTop.f_104203_ = 1.1780972f;
            this.RightLegBottom.f_104203_ = -2.5743606f;
            this.RightFoot.f_104203_ = 0.61086524f;
        } else if (this.isBuildingNest) {
            this.LeftLegTop.f_104203_ = 0.3926991f;
            this.LeftLegBottom.f_104203_ = -0.5235988f;
            this.LeftFoot.f_104203_ = 0.17453292f;
            this.RightLegTop.f_104203_ = 0.3926991f + Mth.m_14089_((float)(ageInTicks * 0.45f));
            this.RightLegBottom.f_104203_ = -0.5235988f;
            this.RightFoot.f_104203_ = 0.17453292f;
        } else {
            this.LeftLegTop.f_104203_ = 0.3926991f + Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
            this.LeftLegBottom.f_104203_ = -0.5235988f;
            this.LeftFoot.f_104203_ = 0.17453292f;
            this.RightLegTop.f_104203_ = 0.3926991f + Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount;
            this.RightLegBottom.f_104203_ = -0.5235988f;
            this.RightFoot.f_104203_ = 0.17453292f;
        }
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            matrixStack.m_85841_(0.6f, 0.6f, 0.6f);
            matrixStack.m_252880_(0.0f, 1.0f, 0.0f);
        } else if (this.isLayingEgg) {
            matrixStack.m_85837_(0.0, 0.65, 0.0);
        }
        this.Body.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171488_(-4.5f, -5.0f, -4.0f, 9.0f, 9.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(42, 53).m_171488_(-4.0f, -5.0f, -7.0f, 8.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)8.0f, (float)0.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition Neck = Body.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(29, 0).m_171488_(-1.5f, -5.0f, -0.5f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-7.5f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition NeckTop = Neck.m_171599_("NeckTop", CubeListBuilder.m_171558_().m_171514_(29, 11).m_171488_(-1.0f, -7.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-5.0f, (float)1.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition Head = NeckTop.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(29, 22).m_171488_(-1.5f, -3.0f, -2.75f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-7.0f, (float)0.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition Mouth = Head.m_171599_("Mouth", CubeListBuilder.m_171558_().m_171514_(29, 30).m_171488_(-1.0f, -1.3f, -1.25f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-3.0f));
        PartDefinition MouthTop = Mouth.m_171599_("MouthTop", CubeListBuilder.m_171558_().m_171514_(29, 30).m_171488_(-1.0f, -0.75f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.8f, (float)-0.25f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition LeftWing = Body.m_171599_("LeftWing", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171488_(-0.5f, -2.0f, 0.0f, 1.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.5f, (float)-2.0f, (float)-3.0f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition RightWing = Body.m_171599_("RightWing", CubeListBuilder.m_171558_().m_171514_(44, 37).m_171488_(-0.5f, -2.0f, 0.0f, 1.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.5f, (float)-2.0f, (float)-3.0f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition LeftLegTop = Body.m_171599_("LeftLegTop", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)2.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition LeftLegBottom = LeftLegTop.m_171599_("LeftLegBottom", CubeListBuilder.m_171558_().m_171514_(9, 21).m_171488_(-1.0f, -0.6f, -1.15f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)7.0f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition LeftFoot = LeftLegBottom.m_171599_("LeftFoot", CubeListBuilder.m_171558_().m_171514_(18, 27).m_171488_(-1.0f, -0.5f, -2.1f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)7.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition RightLegTop = Body.m_171599_("RightLegTop", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)2.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition RightLegBottom = RightLegTop.m_171599_("RightLegBottom", CubeListBuilder.m_171558_().m_171514_(9, 32).m_171488_(-1.0f, -0.6f, -1.15f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)7.0f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition RightFoot = RightLegBottom.m_171599_("RightFoot", CubeListBuilder.m_171558_().m_171514_(18, 38).m_171488_(-1.0f, -0.5f, -2.1f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)7.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition Back = Body.m_171599_("Back", CubeListBuilder.m_171558_().m_171514_(46, 10).m_171488_(-4.0f, -1.0f, -0.5f, 8.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)7.5f));
        PartDefinition add1 = Back.m_171599_("add1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -5.0f, -0.5f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition add1Left = add1.m_171599_("add1Left", CubeListBuilder.m_171558_().m_171514_(9, 0).m_171488_(-1.0f, -5.0f, -2.5f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition add1Right = add1.m_171599_("add1Right", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171488_(-1.0f, -5.0f, -2.5f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition add2 = Back.m_171599_("add2", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171488_(-1.5f, -5.0f, -0.5f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)0.0f, (float)-1.1781f, (float)0.0f, (float)0.0f));
        PartDefinition add2Left = add2.m_171599_("add2Left", CubeListBuilder.m_171558_().m_171514_(9, 7).m_171488_(-1.0f, -5.0f, -2.5f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.6545f));
        PartDefinition add2Right = add2.m_171599_("add2Right", CubeListBuilder.m_171558_().m_171514_(9, 14).m_171488_(-1.0f, -5.0f, -2.5f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.7418f));
        PartDefinition add3 = Back.m_171599_("add3", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171488_(-1.5f, -5.0f, -0.5f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)0.0f, (float)-1.6581f, (float)0.0f, (float)0.0f));
        PartDefinition add3Left = add3.m_171599_("add3Left", CubeListBuilder.m_171558_().m_171514_(16, 7).m_171488_(-1.0f, -5.0f, -2.5f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.6981f));
        PartDefinition add3Right = add3.m_171599_("add3Right", CubeListBuilder.m_171558_().m_171514_(16, 14).m_171488_(-1.0f, -5.0f, -2.5f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.6981f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

